
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Feb 07 09:42:53 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MW_ATP_UTIL_INIT.c#1:csrc:1
   *  \author arield
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/*lint --e(553) */
/*lint --e(713) */
/************* Include Files **************************************/
#include "CRYS.h"
#include "MW_ATP_defines.h"
#include "MW_ATP_UTIL_funcs.h"
#include "MW_ATP_UTIL_sep.h"

#include "Init_CC.h"
#include "cc_start_addr.h"

extern DxUint32_t TST_ResAddr;
extern DxUint32_t TST_CacheAddr;
extern DxUint32_t TST_ExtCacheAddr;
/************************ Defines **********************************/
/************************ Enums ************************************/
/************************ Typedefs *********************************/
/************************ Global Data ******************************/
/*************** Private function prototype ************************/

/************************ Public Functions *************************/
/********************************************************************************
 * Function Name:
 *  MW_TST_DX_CC_INIT
 *
 * Inputs:
 *  None.
 *  
 * Outputs:
 *  DxError_t - DX_CC_INIT return code
 *
 * Description:
 * The following function calls the correct DX_CC_INIT function.
 *
 ********************************************************************************/
DxUint32_t  MW_TST_DX_CC_INIT(void) 
{
     
    return DX_CC_Init(DX_CC_HOST_MEMORY_BASE_ADDR,
                      		     DX_CC_HOST_SHARED_AREA_ADDR,
                      		     DX_CC_HOST_SHARED_AREA_SIZE,
                      		     TST_ResAddr,
                   		     	 TST_CacheAddr,
                   		     	 TST_ExtCacheAddr,
                      		     DX_CC_HOST_D_CACHE_BASE_ADDR, /*D- cache base address*/
                      		     0x0, /* D- cache size*/
                      		     0x0,  /* heap size*/
                      		     0x0,  /* stack size*/
                      		     0x0);

}



